% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_retrieve_sorted_bitlinks_by_groups}
\alias{bitly_retrieve_sorted_bitlinks_by_groups}
\title{Retrieve Sorted Bitlinks for Group}
\usage{
bitly_retrieve_sorted_bitlinks_by_groups(
  group_guid = NULL,
  unit = "day",
  units = -1,
  sort = "clicks",
  size = 50,
  unit_reference = NULL,
  showRequestURL = FALSE
)
}
\arguments{
\item{group_guid}{- a GUID for a Bitly group}

\item{unit}{- A unit of time}

\item{units}{- An integer representing the time units to query data for. pass -1 to return all units of time.}

\item{sort}{- required, Enum:"clicks" - The type of sorting that you would like to do}

\item{size}{- The quantity of items to be be returned}

\item{unit_reference}{- string | An ISO-8601 timestamp, indicating the most recent time for 
which to pull metrics. Will default to current time.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug
purposes.}
}
\description{
See \url{https://dev.bitly.com/v4/#operation/getSortedBitlinks}
This will retrieve a paginated response for Bitlinks that are sorted for the Group
}
\examples{
\dontrun{
bitly_retrieve_sorted_bitlinks_by_groups(group_guid = "", sort = "clicks")
}
}
