% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{param_set}
\alias{param_set}
\title{Set the value associated with a parameter in a URL's query.}
\usage{
param_set(urls, key, value)
}
\arguments{
\item{urls}{a vector of URLs. These should be decoded (with \code{url_decode})
but do not have to have been otherwise manipulated.}

\item{key}{a string representing the key to modify the value of (or insert wholesale
if it doesn't exist within the URL).}

\item{value}{a value to associate with the key. This can be a single string,
or a vector the same length as \code{urls}}
}
\value{
the original vector of URLs, but with modified/inserted key-value pairs. If the
URL is \code{NA}, the returned value will be - if the key or value are, no insertion
will be made.
}
\description{
URLs often have queries associated with them, particularly URLs for
APIs, that look like \code{?key=value&key=value&key=value}. \code{param_set}
allows you to modify key/value pairs within query strings, or even add new ones
if they don't exist within the URL.
}
\examples{
# Set a URL parameter where there's already a key for that
param_set("https://en.wikipedia.org/api.php?action=query", "action", "pageinfo")

# Set a URL parameter where there isn't.
param_set("https://en.wikipedia.org/api.php?list=props", "action", "pageinfo")

}
\seealso{
\code{\link{param_get}} to retrieve the values associated with multiple keys in
a vector of URLs, and \code{\link{param_remove}} to strip key/value pairs from a URL entirely.
}

