% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fns.R
\name{get_biphasic}
\alias{get_biphasic}
\title{Compute the biphasic model curve}
\usage{
get_biphasic(params, timevec)
}
\arguments{
\item{params}{named numeric vector of all parameters needed to compute the biphasic model, V(t)}

\item{timevec}{numeric vector of the times, t, at which V(t) should be calculated}
}
\value{
numeric vector of viral load predictions, V(t), for each time point in 'timevec'
}
\description{
This function calculates the biphasic model, V(t), for a vector of input times, t
}
\examples{

get_biphasic(params = c(A = 10000, delta = 0.03, B = 1000, gamma = 0.68),
             timevec = seq(1, 100, length.out = 100))

}
