% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master_fn.R
\name{ushr}
\alias{ushr}
\title{Master function}
\usage{
ushr(data, filter = TRUE, detection_threshold = 20, censortime = 365,
  decline_buffer = 500, initial_buffer = 3, threshold_buffer = 10,
  VL_max_decline = 10000, CI_max_diff = 1000, n_min_single = 3,
  n_min_biphasic = 6, nsuppression = 1,
  forward_param_transform_fn = list(log, log, log, log),
  inv_param_transform_fn = list(exp, exp, exp, exp),
  initial_params = c(A = 10000, delta = 0.68, B = 1000, gamma = 0.03),
  searchmethod = "Nelder-Mead")
}
\arguments{
\item{data}{raw data set. Must be a data frame with the following columns: 'id' - stating the unique identifier for each subject; 'vl' - numeric vector stating the viral load measurements for each subject; 'time'- numeric vector stating the time at which each measurement was taken.}

\item{filter}{Logical TRUE/FALSE indicating whether the data should be processed (highly recommended) prior to model fitting. Default is TRUE.}

\item{detection_threshold}{numeric value indicating the detection threshold of the assay used to measure viral load. Measurements below this value will be assumed to represent undetectable viral levels. Default value is 20.}

\item{censortime}{numeric value indicating the maximum time point to include in the analysis. Subjects who do not suppress viral load below the detection threshold within this time will be discarded from model fitting. Units are assumed to be same as the 'time' measurements. Default value is 365.}

\item{decline_buffer}{numeric value indicating the maximum allowable deviation of values away from a strictly decreasing sequence in viral load. This allows for e.g. measurement noise and small fluctuations in viral load. Default value is 500.}

\item{initial_buffer}{integer value indicating the maximum number of initial observations from which the beginning of each trajectory will be chosen. Default value is 3.}

\item{threshold_buffer}{numeric value indicating the range above the detection threshold which represents potential skewing of model fits. Subjects with their last two data points within this range will have the last point removed. Default value is 10.}

\item{VL_max_decline}{numeric value indicating the maximum allowable difference between first and second viral load measurements. Default is 10,000.}

\item{CI_max_diff}{numeric value indicating the maximum allowable relative difference between lower and upper 95\% confidence intervals i.e. (upper CI - lower CI)/lower CI. Default is 1000.}

\item{n_min_single}{numeric value indicating the minimum number of data points required to be included in the analysis. Defaults to 3. It is highly advised not to go below this threshold.}

\item{n_min_biphasic}{numeric value indicating the minimum number of data points required to fit the biphasic model. Defaults to 6. It is highly advised not to go below this threshold.}

\item{nsuppression}{numerical value (1 or 2) indicating whether suppression is defined as having one observation below the detection threshold, or two sustained observations. Default value is 1.}

\item{forward_param_transform_fn}{list of transformation functions to be used when fitting the model in optim. Defaults to log transformations for all parameters (to allow unconstrained optimization).}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions. Defaults to exponential.}

\item{initial_params}{named numeric vector of initial parameter guesses. Defaults to c(A = 10000, delta = 0.68, B = 1000, gamma = 0.03).}

\item{searchmethod}{optimization algorithm to be passed to 'optim()'. Defaults to 'Nelder-Mead'.}
}
\value{
a list containing the filtered data ('data_filtered'); parameter estimates for the biphasic and single phase models ('biphasicCI' and 'singleCI'); and predictions from the biphasic and single phase models ('biphasic_fits' and 'single_fits').
}
\description{
This function performs the entire analysis, from data filtering to fitting the biphasic/single phase models. The biphasic/single phase models should be used when ART comprises of RTI/PIs.
}
\details{
Steps include:
1. Processing the raw data.
2. Fitting the biphasic model to subjects with eligible data e.g. those with enough data points and reliable confidence interval estimates.
3. Fitting the single phase model to the remaining subjects.
}
\examples{

set.seed(1234567)

simulated_data <- simulate_data(nsubjects = 20)

model_output <- ushr(data = simulated_data)

}
