% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd.R
\name{ustfd_simple}
\alias{ustfd_simple}
\title{Retrieve Fiscal Data API in a single call}
\usage{
ustfd_simple(
  endpoint,
  filter = NULL,
  fields = NULL,
  sort = NULL,
  page_size = NULL,
  page_number = NULL,
  user_agent = "http://github.com/groditi/ustfd"
)
}
\arguments{
\item{endpoint}{required string representing an API endpoint}

\item{filter}{optional list used to subset the data. See \link{filter-syntax} for
more information.}

\item{fields}{optional character vector of the fields to be retrieved}

\item{sort}{optional string or character vector. Ordering defaults to
ascending, to specify descending order precede the field name with '-'}

\item{page_size}{optional integer for pagination}

\item{page_number}{optional integer for pagination}

\item{user_agent}{optional string}
}
\value{
a list containing the following items
\itemize{
\item \code{meta} - the metadata returned by the API
\item \code{data} - the payload returned by the API in table form.
See \code{\link[=ustfd_response_payload]{ustfd_response_payload()}}
}
}
\description{
\code{ustfd_simple()} aggregates the workflow for retrieving data from the API
into a single call.
}
\examples{
\dontrun{
library(ustfd)

exchange_rates <- ustfd_simple(
  'v1/accounting/od/rates_of_exchange',
   fields = c(
    'country_currency_desc', 'exchange_rate','record_date','effective_date'
   ),
   filter = list(
     record_date = c('>=' = '2020-01-01'),
     country_currency_desc = list('in' = c('Canada-Dollar','Mexico-Peso'))
   )
)
}
}
\seealso{
Other ustfd_user: 
\code{\link{endpoint_exists}()},
\code{\link{ustfd_all_pages}()},
\code{\link{ustfd_datasets}()},
\code{\link{ustfd_query}()},
\code{\link{ustfd_table_columns}()},
\code{\link{ustfd_tables}()}
}
\concept{ustfd_user}
