% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_event_table.R
\name{build_event_table}
\alias{build_event_table}
\title{build_event_table}
\usage{
build_event_table(fit, data, cols, skip, mv, percent.sign, digits, p.digits)
}
\arguments{
\item{fit}{Required. Formula, survival::survfit(), survival::coxph(). The formula
must contain a survival::Surv() object as first term. All terms must be present in data.}

\item{data}{Semi-optional. Tibble. Contains data for time-to-event model. Only required
if \'fit\' is a formula.}

\item{cols}{Optional. Character. Columns to use as predictors in time-to-event model.
Defaults to all usable columns in \'data\'.}

\item{skip}{Optional. Character. Names of columns to skip as part of predictor testing.}

\item{mv}{Optional. Logical. Indicates provided \'cols\' should be tested as part of one
multi-variate model. Defaults to FALSE (univariate; seperate models).}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round numerics to. Defaults to 1.}

\item{p.digits}{Optional. Integer. Number of digits to print for p-values. Note that p-values are
still rounded based on \'digits\' parameter. Defaults to 4.}
}
\value{
Data is returned in the form of a tibble containing a row for each parameter.
}
\description{
Creates time-to-event models in an automated fashion and summarizes
them in a tibble.
}
\examples{
library(survival)
library(dplyr)

data_lung <- lung \%>\%
  as_tibble() \%>\%
  mutate_at(vars(inst, status, sex), as.factor) \%>\%
  mutate(status = case_when(status == 1 ~ 0, status == 2 ~ 1))

# Automatically model each parameter
build_event_table(Surv(time, status) ~ 1, skip = 'inst', data = data_lung)

# Automatically model all parameters together
build_event_table(Surv(time, status) ~ 1, skip = 'inst', mv = TRUE, data = data_lung)
}
