% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_row.R
\name{build_row_}
\alias{build_row_}
\title{build_row_}
\usage{
build_row_(
  by = NULL,
  data.default = NULL,
  digits = 1,
  percent.sign = FALSE,
  inverse = FALSE,
  indent = FALSE,
  less.than.one = FALSE,
  label.stats = TRUE,
  parametric = FALSE,
  p.digits = 4,
  remove.na = TRUE,
  ...
)
}
\arguments{
\item{by}{Optional. Character or Quosure. Name of factor or logical column to stratify by
or quosure code to be used by dplyr::mutate to create a grouping variable on the fly
(i.e. quo(pt_id %in% !!(data.followup %>% filter(lto_indexDeath) %>% .$pt_id))) in provided
tibbles. Either must be applicable to all provided tibbles!}

\item{data.default}{Optional. Character. Name of a provided tibble to use as default data source
if the \'data\' parameter is not specified in build_row().}

\item{digits}{Optional. Integer. Number of digits to round numerics to. Defaults to 1.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed for
frequencies. Defaults to TRUE.}

\item{inverse}{Optional. Logical. Indicates to summarize the FALSE/No data of a logical column
(i.e. 'Smoking Hx, yes' -> 'Smoking Hx, no'). Defaults to FALSE (Summarizes TRUE/Yes data).}

\item{indent}{Optional. Logical. Indent a variable labels. Defaults to FALSE.}

\item{less.than.one}{Optional. Logical. Indicates means/medians that round to 0 should be
printed as <1 (i.e. <1 [0-4]). Defaults to FALSE (0).}

\item{label.stats}{Optional. Logical. Whether to append the type of statistic (median, n, mean)
to the row's label. Defaults to TRUE.}

\item{parametric}{Optional. Logical. Indicates parametric testing should be used for comparisons
(Fisher's exact and Student's Unpaired T-Test). Defaults to FALSE (non-parametric; Chi-squared and
Wilcox Rank-sum).}

\item{p.digits}{Optional. Integer. Number of p-value digits to print. Note
that p-values are still rounded based on 'digits' parameter. Defaults to 4.}

\item{remove.na}{Optional. Logical. Remove NA from denominator in frequency calculations.
Defaults to TRUE.}

\item{...}{Optional. Any other variables or tibbles you want to make available for use in
build_row(). I recommend naming each of these with a starting '.' to ensure they
do not conflict with other variables (i.e. build_row_(.index = data.index,
.radiology = data.radiology)). Note that this is optional as a tibble may be provided to
a resultant row function on the fly instead.}
}
\value{
A custom build_row() function. See documentation for behavior.
}
\description{
A factory function to create a copy of build_row() with built in data and
pre-specified rules for row formatting.
}
\examples{
library(dplyr)

data_mtcars <- datasets::mtcars \%>\%
  as_tibble() \%>\%
  mutate_at(vars('vs', 'am'), as.logical) \%>\%
  mutate_at(vars('gear', 'carb', 'cyl'), as.factor)

# Create instance of build_row() with custom defaults
row <- build_row_(
  by = 'am',
  percent.sign = FALSE,
  less.than.one = TRUE,
  label.stat = FALSE,

  # Data (more than one allowed!)
  default.data = '.mtcars',
  .mtcars = data_mtcars,
  .mtcars_alt = data_mtcars
)

row() \%>\% # Count row
row(label = 'Car Features') \%>\% # Row without data
row(label = 'Miles per gallon', col = 'mpg') \%>\%
row(col = 'cyl', data = '.mtcars \%>\% filter(mpg > 20)') \%>\% # subset of data
row(label = 'Horsepower', col = 'hp') \%>\%
row(label = 'Engine Shape', col = 'vs', percent.sign = TRUE, data = '.mtcars_alt')
}
