% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurtosis.R
\name{kurtosis}
\alias{kurtosis}
\title{Sample Kurtosis}
\usage{
kurtosis(x, kurt.type = NULL, kurt.excess = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{A data vector/matrix}

\item{kurt.type}{The type of kurtosis statistic used ('Moment', 'Fisher Pearson' or 'Adjusted Fisher Pearson')}

\item{kurt.excess}{Logical value; if \code{TRUE} the function gives the excess kurtosis (instead of raw kurtosis)}

\item{na.rm}{Logical value; if \code{TRUE} the function removes \code{NA} values}
}
\value{
The sample kurtosis of the data vector/matrix
}
\description{
\code{kurtosis} returns the sample kurtosis of a data vector/matrix
}
\details{
This function computes the sample kurtosis for a data vector or matrix.  For a vector input the function returns a single value for the
sample kurtosis of the data.  For a matrix input the function treats each column as a data vector and returns a vector of values for the
sample kurtosis of each of these datasets.  The function can compute different types of kurtosis statistics using the \code{kurt.type} input.
}
\examples{
kurtosis(rnorm(1000))
kurtosis(rexp(1000))
}
