% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{scut_threshold}
\alias{scut_threshold}
\alias{scut_threshold.default}
\alias{scut_threshold.mlresult}
\title{SCut Score-based method}
\usage{
scut_threshold(
  prediction,
  expected,
  loss.function = NA,
  cores = getOption("utiml.cores", 1)
)

\method{scut_threshold}{default}(
  prediction,
  expected,
  loss.function = NA,
  cores = getOption("utiml.cores", 1)
)

\method{scut_threshold}{mlresult}(
  prediction,
  expected,
  loss.function = NA,
  cores = getOption("utiml.cores", 1)
)
}
\arguments{
\item{prediction}{A matrix or mlresult.}

\item{expected}{The expected labels for the prediction. May be a matrix with
the label values or a mldr object.}

\item{loss.function}{A loss function to be optimized. If you want to use your
own error function see the notes and example. (Default: Mean Squared Error)}

\item{cores}{The number of cores to parallelize the computation Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}
}
\value{
A numeric vector with the threshold values for each label
}
\description{
This is a label-wise method that adjusts the threshold for each label to
achieve a specific loss function using a validation set or cross validation.
}
\details{
Different from the others threshold methods instead of return the bipartition
results, it returns the threshold values for each label.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default scut_threshold

\item \code{mlresult}: Mlresult scut_threshold
}}

\note{
The loss function is a R method that receive two vectors, the expected
 values of the label and the predicted values, respectively. Positive values
 are represented by the 1 and the negative by the 0.
}
\examples{
names <- list(1:10, c("a", "b", "c"))
prediction <- matrix(runif(30), ncol = 3, dimnames = names)
classes <- matrix(sample(0:1, 30, rep = TRUE), ncol = 3, dimnames = names)
thresholds <- scut_threshold(prediction, classes)
fixed_threshold(prediction, thresholds)

\donttest{
# Penalizes only FP predictions
mylossfunc <- function (real, predicted) {
   mean(predicted - real * predicted)
}
prediction <- predict(br(toyml, "RANDOM"), toyml)
scut_threshold(prediction, toyml, loss.function = mylossfunc, cores = 2)
}
}
\references{
Fan, R.-E., & Lin, C.-J. (2007). A study on threshold selection for
  multi-label classification. Department of Computer Science, National
  Taiwan University.

 Al-Otaibi, R., Flach, P., & Kull, M. (2014). Multi-label Classification: A
  Comparative Study on Threshold Selection Methods. In First International
  Workshop on Learning over Multiple Contexts (LMCE) at ECML-PKDD 2014.
}
\seealso{
Other threshold: 
\code{\link{fixed_threshold}()},
\code{\link{lcard_threshold}()},
\code{\link{mcut_threshold}()},
\code{\link{pcut_threshold}()},
\code{\link{rcut_threshold}()},
\code{\link{subset_correction}()}
}
\concept{threshold}
