% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CpvMF.R
\name{CpvMF}
\alias{CpvMF}
\title{Normalization constant of von Mises - Fisher distribution.}
\usage{
CpvMF(p, k)
}
\arguments{
\item{p}{as sphere dimension.}

\item{k}{as the intensity parameter.}
}
\value{
the normalization constant.
}
\description{
\code{CpvMF} returns the normalization constant of von Mises - Fisher density.
}
\details{
The probability density function of the von Mises - Fisher distribution is defined by :
\deqn{f(z|theta) = C_p(|theta|)\exp{(z theta)}}
\eqn{|theta|} is the intensity parameter and \eqn{\frac{theta}{|theta|}} the mean directional parameter. The normalization constant \eqn{C_p()} depends 
on the Bessel function of the first kind. See more details \href{https://en.wikipedia.org/wiki/Von_Mises-Fisher_distribution}{here}.
}
\examples{

CpvMF(2,3.1)

}
\references{
Wood, A. T. (1994). Simulation of the von Mises Fisher distribution. \emph{Communications in statistics-simulation and computation}, 23(1), 157-164. \url{https://www.tandfonline.com/doi/abs/10.1080/03610919408813161}.

Hornik, K., & Grun, B. (2014). \pkg{movMF}: An \R package for fitting mixtures of von Mises-Fisher distributions. \emph{Journal of Statistical Software}, 58(10), 1-31. \url{https://epub.wu.ac.at/4893/}.
}
\seealso{
\code{\link{rvMF}} and \code{\link{dvMF}}
}
\keyword{coordinates}
\keyword{directional}
\keyword{distribution}
\keyword{simulations}
\keyword{statistics}
