% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_immunization.R
\name{make_immunization}
\alias{make_immunization}
\title{Construct Information of Immunization}
\usage{
make_immunization(
  data_set,
  outcome_date_col,
  censoring_date_col,
  vacc_date_col,
  vacc_name_col,
  vaccinated_status,
  unvaccinated_status,
  immunization_delay,
  end_cohort,
  take_first = FALSE
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date.}

\item{vacc_date_col}{Name of the column(s) that contain the vaccine dates.}

\item{vacc_name_col}{Name of the column(s) that contain custom vaccine
names for the vaccines (e.g. brand name, type of vaccine)}

\item{vaccinated_status}{Status assigned to the vaccinated population.}

\item{unvaccinated_status}{Status assigned to the unvaccinated population.}

\item{immunization_delay}{Characteristic time in days before the patient
is considered immune.}

\item{end_cohort}{End date of the study.}

\item{take_first}{\code{FALSE}: takes the latest vaccine date. \code{TRUE}: takes the
earliest vaccine date.}
}
\value{
Original \code{data.frame} passed in \code{data_set} and additional columns
containing information on the immunization.
}
\description{
This function returns a \code{data.frame} with the relevant
information on immunization for the study. An individual is considered
immunized after the characteristic time for the immune response of the
vaccine passes. This time is provided to the function by the parameter
\code{immunization_delay}. By default, it is set to 0. The function searches
for vaccine dates based on the end of the follow-up period of each
individual defined by the censoring date (if provided), outcome delay
(if present), and end of the study.

The function also works with vaccination information spread across several
columns. If this is the case, the parameter \code{vacc_date_col} must be passed
as a vector with the names of all the columns to use.
The function uses by default the latest date found. However, it can also
select the first date by setting \code{take_first = TRUE}.

The function returns a column with the immunization date (\code{immunization})
and a vaccine status column (\code{vaccine_status}) that is constructed based on
\code{immunization}. For several vaccines, the function also returns the name of
the column of the vaccine that was selected as immunizing
(\code{immunizing_dose}). If different custom names (e.g., brands) are associated
with each vaccine date, the function can return the custom name of the
vaccine selected as immunizing. This information must be passed in the
parameter \code{vacc_name_col}, as a vector in the same order as \code{vacc_date_col}.
}
\keyword{internal}
