% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_eff_plot.R
\name{plot_survival}
\alias{plot_survival}
\title{Plot the Survival Probability Based on the Kaplan-Meier Model}
\usage{
plot_survival(km, percentage = TRUE, cumulative = FALSE)
}
\arguments{
\item{km}{Kaplan-Meier estimation created with \code{km_model}.}

\item{percentage}{If \code{TRUE}, returns probability in percentage.}

\item{cumulative}{If \code{TRUE}, returns cumulative incidence}
}
\value{
\code{{ggplot2}} object with plot of survival or cumulative incidence.
}
\description{
This function relies on the implementation of the Kaplan-Meier
model from the package \code{{survival}}. It returns a plot of the Survival
Probability or the Cumulative Hazard (if cumulative = TRUE).
The return is a ggplot2 element of the curves with 95\% C.I. It is possible
to manipulate the colors, labels, legend, and most of the graphic elements.
}
\keyword{internal}
