% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{in_range}
\alias{in_range}
\alias{in_range.default}
\alias{in_range.character}
\title{Check variable range}
\usage{
in_range(x, min, max, ...)

\method{in_range}{default}(x, min, max, strict = FALSE, ...)

\method{in_range}{character}(x, min, max, strict = FALSE, format = "auto", ...)
}
\arguments{
\item{x}{A bare (unquoted) variable name.}

\item{min}{lower bound}

\item{max}{upper bound}

\item{...}{arguments passed to other methods}

\item{strict}{\code{[logical]} Toggle between including the range boundaries
(default) or not including them (when strict=TRUE).}

\item{format}{\code{[character]} of \code{NULL}. If \code{format=NULL} the
character vector is interpreted as is. And the whether a character lies
within a character range is determined by the collation order set by the
current locale. See the details of "\code{\link{<}}".  If \code{format} is
not \code{NULL}, it specifies how to interpret the character vector as a
time period.  It can take the value \code{"auto"} for automatic detection or
a specification passed to \code{\link{strptime}}. Automatically detected
periods are of the form year: \code{"2020"}, yearMmonth: \code{"2020M01"},
yearQquarter: \code{"2020Q3"}, or year-Qquarter: \code{"2020-Q3"}.}
}
\description{
Test wether a variable falls within a range.
}
\examples{

d <- data.frame(
   number = c(3,-2,6)
 , time   = as.Date(c("2018-02-01", "2018-03-01", "2018-04-01"))
 , period = c("2020Q1", "2021Q2", "2020Q3") 
)

rules <- validator(
   in_range(number, min=-2, max=7, strict=TRUE)
 , in_range(time,   min=as.Date("2017-01-01"), max=as.Date("2018-12-31"))
 , in_range(period, min="2020Q1", max="2020Q4")
)

result <- confront(d, rules)
values(result)


}
