% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_complement.r
\name{bed_complement}
\alias{bed_complement}
\title{Identify intervals in a genome not covered by a query.}
\usage{
bed_complement(x, genome)
}
\arguments{
\item{x}{tbl of intervals}

\item{genome}{chrom sizes}
}
\value{
\code{data_frame}
}
\description{
Identify intervals in a genome not covered by a query.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1',      1,      10,
  'chr1',      75,    100    
)

genome <- tibble::tribble(
  ~chrom, ~size, 
  'chr1', 200
)

bed_glyph(bed_complement(x, genome))

genome <- tibble::tribble(
   ~chrom,  ~size,
   "chr1", 500,
   "chr2", 600,
   "chr3", 800
) 

x <- tibble::tribble(
   ~chrom, ~start, ~end,
   "chr1", 100,    300,
   "chr1", 200,    400,
   "chr2", 1,      100,
   "chr2", 200,    400,
   "chr3", 500,    600
)

# intervals not covered by x
bed_complement(x, genome)

}
\seealso{
Other single-set-ops: \code{\link{bed_cluster}},
  \code{\link{bed_flank}}, \code{\link{bed_merge}},
  \code{\link{bed_random}}, \code{\link{bed_shift}},
  \code{\link{bed_shuffle}}, \code{\link{bed_slop}}
}
