% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbls.r
\name{as.tbl_interval}
\alias{as.tbl_interval}
\alias{as.tbl_interval.tbl_df}
\alias{as.tbl_interval.data.frame}
\alias{as.tbl_interval.GRanges}
\title{Coerce objects to tbl_intervals.}
\usage{
as.tbl_interval(x)

\method{as.tbl_interval}{tbl_df}(x)

\method{as.tbl_interval}{data.frame}(x)

\method{as.tbl_interval}{GRanges}(x)
}
\arguments{
\item{x}{object to convert to tbl_interval.}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}}
}
\description{
This is an S3 generic. valr includes methods to coerce tbl_df and GRanges
objects.
}
\examples{
\dontrun{
gr <- GenomicRanges::GRanges(
        seqnames = S4Vectors::Rle(
                     c("chr1", "chr2", "chr1", "chr3"),
                     c(1, 1, 1, 1)),
        ranges   = IRanges::IRanges(
                     start = c(1, 10, 50, 100),
                     end = c(100, 500, 1000, 2000),
                     names = head(letters, 4)),
        strand   = S4Vectors::Rle(
                     c("-", "+"), c(2, 2))
      )

as.tbl_interval(gr)

# There are two ways to convert a tbl_interval to GRanges:

gr <- GenomicRanges::GRanges(
        seqnames = S4Vectors::Rle(x$chrom),
        ranges   = IRanges::IRanges(
                     start = x$start + 1,
                     end = x$end,
                     names = x$name),
        strand   = S4Vectors::Rle(x$strand)
        )
# or:

gr <- GenomicRanges::makeGRangesFromDataFrame(dplyr::mutate(x, start = start +1))

}

}
