% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bed.r
\name{read_bed}
\alias{read_bed}
\alias{read_bed12}
\alias{read_bedgraph}
\alias{read_narrowpeak}
\alias{read_broadpeak}
\title{Read BED and related files.}
\usage{
read_bed(
  filename,
  col_types = bed12_coltypes,
  sort = TRUE,
  ...,
  n_fields = NULL
)

read_bed12(filename, ...)

read_bedgraph(filename, ...)

read_narrowpeak(filename, ...)

read_broadpeak(filename, ...)
}
\arguments{
\item{filename}{file or URL}

\item{col_types}{column type spec for \code{\link[readr:read_delim]{readr::read_tsv()}}}

\item{sort}{sort the tbl by chrom and start}

\item{...}{options to pass to \code{\link[readr:read_delim]{readr::read_tsv()}}}

\item{n_fields}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
\link{ivl_df}
}
\description{
read functions for BED and related formats. Filenames can be
local file or URLs. The read functions load data into tbls with consistent
\code{chrom}, \code{start} and \code{end} colnames.
}
\details{
\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}

\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}

\url{https://genome.ucsc.edu/goldenPath/help/bedgraph.html}

\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format12}

\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format13}
}
\examples{
# read_bed assumes 3 field BED format.
read_bed(valr_example("3fields.bed.gz"))

# result is sorted by chrom and start unless `sort = FALSE`
read_bed(valr_example("3fields.bed.gz"), sort = FALSE)


read_bed12(valr_example("mm9.refGene.bed.gz"))


read_bedgraph(valr_example("test.bg.gz"))


read_narrowpeak(valr_example("sample.narrowPeak.gz"))


read_broadpeak(valr_example("sample.broadPeak.gz"))

}
\seealso{
Other read functions: 
\code{\link{read_genome}()},
\code{\link{read_vcf}()}
}
\concept{read functions}
