% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payoffs.R
\docType{class}
\name{payoff_GMWB}
\alias{payoff_GMWB}
\title{GMWB payoff class}
\format{\code{\link{R6Class}} object.}
\usage{
payoff_GMWB
}
\value{
Object of \code{\link{R6Class}}
}
\description{
Class providing the  periodic payment of a GMWB contract.
It is stated as a given percentage of the premium.
}
\section{Methods}{

 \describe{
  \item{\code{new}}{Initialize method.
   The arguments are a non negative scalar with the premium and a
   scalar between 0 and 1 with the percentage.}
  \item{\code{set_premium}}{Stores the premium in a
   private field. The argument is a non negative scalar}
  \item{\code{get_premium}}{Returns the premium
  as non negative scalar}
  \item{\code{set_beta}}{Sets the percentage. The argument is
  a scalar between 0 and 1}
  \item{\code{get_beta}}{Gets the percentage}
  \item{\code{get_payoff}}{Gets the payoff}
}
}

\examples{
premium <- 100
beta <- 0.15
GMWB_payment <- payoff_GMWB$new(premium, beta)
GMWB_payment$get_payoff()
}
\keyword{datasets}
