% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step4_MonteCarloValuation.R
\name{calcMortFactors}
\alias{calcMortFactors}
\title{Calculates the mortality factors (t - 1)px q(x + t - 1) and tpx required to
valuate the inPolicy. Extract gender, age (birth date & current date),
valuation date (current date), and maturity date from inPolicy, mortality
rates from mortTable.}
\usage{
calcMortFactors(inPolicy, mortTable, dT = 1/12)
}
\arguments{
\item{inPolicy}{A vector containing 45 attributes of a VA policy,
usually a row of a VA portfolio dataframe.}

\item{mortTable}{A dataframe with three columns of doubles representing the
mortality table.}

\item{dT}{A double of stepsize in years; dT = 1 / 12 would be monthly.}
}
\value{
Outputs a two-column data frame of doubles of mortFactors (t - 1)px
  q(x + t - 1) and tpx.
}
\description{
Calculates the mortality factors (t - 1)px q(x + t - 1) and tpx required to
valuate the inPolicy. Extract gender, age (birth date & current date),
valuation date (current date), and maturity date from inPolicy, mortality
rates from mortTable.
}
\examples{
exPolicy <- VAPort[1, ]
calcMortFactors(exPolicy, mortTable, dT = 1 / 12)
}
