% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getResTypeCounts}
\alias{getResTypeCounts}
\title{Get ResType Counts}
\usage{
getResTypeCounts(res.types)
}
\arguments{
\item{res.types}{A vector of strings containing a combination of the 20
ResTypes.}
}
\value{
a vector of numbers indicating the counts of each ResType. The
vector is ordered based on the \code{names.ResTypes} with ResTypes not
included assigned a value of zero (0).
}
\description{
Counts the number of ResType within the provided string.
}
\details{
This is a wrapper for the \code{\link[base:table]{base::table()}} function. The
vector of ResType are passed to the function, non-standard ResType are
removed, the ResType are counted, and the counts are ordered based on the
\code{names.ResTypes} constant.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  set.seed(13)
  num.ResTypes <- sample(1:10, 20, replace = TRUE)
  res.types <- rep(names.residues, num.ResTypes)
  getResTypeCounts(res.types)
  # [1] 8  3  4  1 10  1  6  8  9  1  7  9  9  6  6  4  4  6  9  7
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
