% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HydrophilicityEvaluation.R
\name{getResidueData}
\alias{getResidueData}
\title{Number of Residues and Solvent Accessible/Exposed Residues}
\usage{
getResidueData(atoms.oi.prot, SurExp.res.atoms.tf)
}
\arguments{
\item{atoms.oi.prot}{The protein \code{data.frame} with the \code{SASA} and \code{SASA lost}
values for each protein atom.}

\item{SurExp.res.atoms.tf}{\code{TRUE}/\code{FALSE} vector indicating if an atom is
solvent exposed/accessible}
}
\value{
This function returns:
\itemize{
\item \strong{num.res}: number of residues within the structure
\item \strong{num.res.buried}: number of residues with \emph{\strong{NO}} solvent accessible
surface area
\item \strong{num.res.SurExp}: number of residues with solvent accessible surface
area
\item \strong{pct.res.SurExp}: percentage of residues with solvent accessible
surface area
\item \strong{SASA.total}: total protein solvent accessible surface area;
Angstroms^2^
\item \strong{SASA.lost}: total protein solvent accessible surface area lost due to
bound waters; Angstroms^2^
\item \strong{pct.SASA.exposed}: percentage protein solvent accessible surface area
\eqn{(SASA.total - SASA.lost) / SASA.total}
}

These values are returned in \code{df.residue.hydro} of the results of
\code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}}
}
\description{
Calculate the number of residues and solvent exposed residues.
}
\details{
This function is called within \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}} to
provide general solvent accessibility data for the protein structure of
interest.
}
\examples{
  \dontrun{
  getResidueData(atoms.oi.prot = PDB.1hai.aoi.clean.SASA.prot,
        SurExp.res.atoms.tf = PDB.1hai.SurExp.res.atoms.tf)
  }

}
\seealso{
Other "Hydrophilicity Evaluation" "Bound Water Environment": \code{\link{HydrophilicityEvaluation}},
  \code{\link{calcAtomClassHydrophilicity}},
  \code{\link{calcAtomHydrationEstimate}},
  \code{\link{getProtAtomsNearWater}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
