% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_read_block.R
\name{vapour_write_raster_block}
\alias{vapour_write_raster_block}
\title{Write data to a block \emph{in an existing file}.}
\usage{
vapour_write_raster_block(
  dsource,
  data,
  offset,
  dimension,
  band = 1L,
  overwrite = FALSE
)
}
\arguments{
\item{dsource}{data source name}

\item{data}{data vector, length should match  \code{prod(dimension)} or length 1 allowed}

\item{offset}{offset to start}

\item{dimension}{dimension to write}

\item{band}{which band to write to (1-based)}

\item{overwrite}{set to FALSE as a safety valve to not overwrite an existing file}
}
\value{
a logical value indicating success (or failure) of the write
}
\description{
Be careful! The write function doesn't create a file, you have to use an existing one.
Don't write to a file you don't want to update by mistake.
}
\examples{
f <- system.file("extdata", "sst.tif", package = "vapour")
v <- vapour_read_raster_block(f, c(0L, 0L), dimension = c(2L, 3L), band = 1L)
file.copy(f, tf <- tempfile(fileext = ".tif"))
try(vapour_write_raster_block(tf, data = v[[1]], offset = c(0L, 0L), 
               dimension = c(2L, 3L), band = 1L))
if (file.exists(tf)) file.remove(tf)
}
