% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour-helpers.R
\name{vapour_gdal_version}
\alias{vapour_gdal_version}
\alias{vapour_all_drivers}
\alias{vapour_driver}
\title{GDAL version and drivers.}
\usage{
vapour_gdal_version()

vapour_all_drivers()

vapour_driver(dsource)
}
\arguments{
\item{dsource}{data source string (i.e. file name or URL or database connection string)}
}
\description{
Return information about the GDAL library in use.
}
\details{
\code{vapour_gdal_version} returns the version of GDAL as a string. This corresponds to the "--version"
as described for "GDALVersionInfo". \href{https://www.gdal.org/}{GDAL documentation}.

\code{vapour_all_drivers} returns the names and capabilities of all available drivers, in a list. This contains:
\itemize{
\item \code{driver} the driver (short) name
\item \code{name} the (long) description name
\item \code{vector} logical vector indicating a vector driver
\item \code{raster} logical vector indicating a raster driver
\item \code{create} driver can create (note vapour provides no write capacity)
\item \code{copy}   driver can copy (note vapour provides no write capacity)
\item \code{virtual} driver has virtual capabilities ('vsi')
}
}
\examples{
vapour_gdal_version()

drv <- vapour_all_drivers()

f <- system.file("extdata/sst_c.gpkg", package = "vapour")
vapour_driver(f)

as.data.frame(drv)[match(vapour_driver(f), drv$driver), ]
}
