% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-info.R
\name{vapour_raster_info}
\alias{vapour_raster_info}
\title{Raster information}
\usage{
vapour_raster_info(x, ..., sds = NULL, min_max = FALSE)
}
\arguments{
\item{x}{data source string (i.e. file name or URL or database connection string)}

\item{...}{currently unused}

\item{sds}{a subdataset number, if necessary}

\item{min_max}{logical, control computing min and max values in source ('FALSE' by default)}
}
\value{
list with vectors 'geotransform', 'dimXY', 'minmax', 'tilesXY', 'projection', 'bands', 'proj4', 'nodata_value',
'overviews', 'filelist' see sections in Details for more on each element
}
\description{
Return the basic structural metadata of a raster source understood by GDAL.
Subdatasets may be specified by number, starting at 1. See
\link{vapour_sds_names} for more.
}
\details{
The structural metadata are

\describe{
\item{extent}{the extent of the data, xmin, xmax, ymin, ymax - these are the lower left and upper right corners of pixels}
\item{geotransform}{the affine transform}
\item{dimension}{dimensions x-y, columns*rows}
\item{minmax}{numeric values of the computed min and max from the first band (optional)}
\item{block}{dimensions x-y of internal tiling scheme}
\item{projection}{text version of map projection parameter string}
\item{bands}{number of bands in the dataset}
\item{projstring}{the proj string version of 'projection'}
\item{nodata_value}{not implemented}
\item{overviews}{the number and size of any available overviews}
\item{filelist}{the list of files involved (may be none, and so will be a single NA character value)}
\item{datatype}{the band type name, in GDAL form 'Byte', 'Int16', 'Float32', etc.}
}

Note that the geotransform is a kind of obscure combination of the extent and dimension, I don't find it
useful and modern GDAL is moving away from needing it so much. Extent is more sensible and used in many places in
a straightforward way.

On access vapour functions will report on the existence of subdatasets while
defaulting to the first subdataset found.
}
\section{Subdatasets}{


Some sources provide multiple data sets, where a dataset is described by a 2-
(or more) dimensional grid whose structure is described by the metadata
described above. Note that \emph{subdataset} is a different concept to \emph{band or
dimension}. Sources that may have multiple data sets are HDF4/HDF5 and
NetCDF, and they are loosely analogous to the concept of \emph{layer} in GDAL
vector data. Variables are usually seen as distinct data but in GDAL and
related 2D-interpretations this concept is leveraged as a 3rd dimension (and
higher). In a GeoTIFF a third dimension might be implicit across bands, i.e.
to express time varying data and so each band is not properly a variable.
Similarly in NetCDF, the data may be any dimensional but there's only an
implicit link for other variables that exist in that same dimensional space.
When using GDAL you are always traversing this confusing realm.

If subdatasets are present but not specified the first is queried. The choice
of subdataset is analogous to the way that the \code{raster} package behaves, and
uses the argument \code{varname}. Variables in NetCDF correspond to subdatasets,
but a single data set might have multiple variables in different bands or in
dimensions, so this guide does not hold across various systems.
}

\section{The Geo Transform}{


From \url{https://gdal.org/user/raster_data_model.html}.

The affine transform consists of six coefficients returned by
\code{GDALDataset::GetGeoTransform()} which map pixel/line coordinates into
georeferenced space using the following relationship:

\code{Xgeo = GT(0) + Xpixel*GT(1) + Yline*GT(2)}

\code{Ygeo = GT(3) + Xpixel*GT(4) + Yline*GT(5)}

They are
\describe{
\item{GT0, xmin}{the x position of the lower left corner of the lower left pixel}
\item{GT1, xres}{the scale of the x-axis, the width of the pixel in x-units}
\item{GT2, yskew}{y component of the pixel width}
\item{GT3, ymax}{the y position of the upper left corner of the upper left pixel}
\item{GT4, xskew}{x component of the pixel height}
\item{GT5, yres}{the scale of the y-axis, the height of the pixel in \emph{negative} y-units}
}

Please note that these coefficients are equivalent to the contents of a
\emph{world file} but that the order is not the same and the world file uses cell
centre convention rather than edge.
\url{https://en.wikipedia.org/wiki/World_file}

Usually the skew components are zero, and so only four coefficients are
relevant and correspond to the offset and scale used to position the raster -
in combination with the number of rows and columns of data they provide the
spatial extent and the pixel size in each direction.  Very rarely a an actual
affine raster will be use with this \emph{rotation} specified within the transform
coefficients.

Calculation of 'minmax' can take a significant amount of time, so it's not done by default. Use
'minmax = TRUE' to do it. (It does perform well, but may be prohibitive for very large or remote sources.)
}

\section{Overviews}{


If there are no overviews this element will simply be a single-element vector
of value 0. If there are overviews, the first value will give the number of overviews and
their dimensions will be listed as pairs of x,y values.
}

\examples{
f <- system.file("extdata", "sst.tif", package = "vapour")
vapour_raster_info(f)
}
\seealso{
vapour_sds_info
}
