% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{extractStruct}
\alias{extractStruct}
\title{Extracting models' structures}
\usage{
extractStruct(m1, m0, randm0)
}
\arguments{
\item{m1}{the model under H1}

\item{m0}{the model under H0}

\item{randm0}{a boolean stating whether the model under H0 contains any random effect}
}
\value{
A list with the following components:
\item{\code{detailStruct}}{a data frame containing the list of the parameters and whether they are tested or not}
\item{\code{nameVarTested}}{the name of the variance components being tested}
\item{\code{nameFixedTested}}{the name of the fixed effects being tested}
\item{\code{dims}}{a list with the dimensions of fixed and random effects, tested or not tested}
\item{\code{structGamma}}{the structure of the covariance matrix of the random effects \code{diag}, \code{full} or 
\code{blockDiag}}
}
\description{
Functions extracting the structure of the models under both hypothesis: the number of fixed and random effects, 
the number of tested fixed and random effects, and the residual dimension, as well as the random effects covariance structure
}
