% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chibarsquare.R
\name{weightsChiBarSquare}
\alias{weightsChiBarSquare}
\title{Monte Carlo approximation of chi-bar-square weights}
\usage{
weightsChiBarSquare(df, V, dimsCone, orthan, control)
}
\arguments{
\item{df}{a vector with the degrees of freedom of the chi-square components of the chi-bar-square distribution}

\item{V}{a positive semi-definite matrix}

\item{dimsCone}{a list with the dimensions of the cone C, expressed on the parameter space scale}

\item{orthan}{a boolean specifying whether the cone is an orthan}

\item{control}{(optional) a list of control options for the computation of the chi-bar-weights, containing 
two elements: \code{parallel} a boolean indicating whether computation should be done in parallel (FALSE 
by default), \code{nb_cores} the number of cores for parallel computing (if \code{parallel=TRUE} but no value is given
for \code{nb_cores}, it is set to number of detected cores minus 1), and \code{M} the Monte Carlo sample
size for the computation of the weights.}
}
\value{
A list containing the estimated weights, the standard deviations of the estimated weights and the
random sample of \code{M} realizations from the chi-bar-square distribution
}
\description{
The function provides a method to approximate the weights of the mixture components, 
when the number of components is known as well as the degrees of freedom of each chi-square distribution 
in the mixture, and given a vector of simulated values from the target \eqn{\bar{\chi}^2(V,C)} 
distribution. Note that the estimation is based on (pseudo)-random Monte Carlo samples. For reproducible
results, one should fix the seed of the (pseudo)-random number generator.
}
