\name{B}

\alias{B}

\title{Coefficient matrix of an estimated VAR(p)}

\description{
  Returns the estimated coefficients of a VAR(p) as a matrix.
}

\usage{
B(x)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varest}}, generated by \command{VAR()}.}
}

\details{
  Given an estimated VAR of the form:
  \deqn{
    \hat{\bold{y}}_t = \hat{A}_1 \bold{y}_{t-1} + \ldots +
    \hat{A}_p \bold{y}_{t-p} + \hat{C}D_t
  }
  the function returns the matrices \eqn{(\hat{A}_1 | \ldots |
    \hat{A}_p | \hat{C})} as a matrix object.
  }

\value{
  A matrix holding the estimated coefficients of a VAR.
}

\author{Bernhard Pfaff}

\seealso{
  \code{\link{A}}, \code{\link{VAR}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
B(var.2c)
}

\keyword{regression}
