\name{normality.test}

\alias{normality.test}

\alias{normality-deprecated}

\title{Normality, multivariate skewness and kurtosis test}

\encoding{latin1}

\description{
  This function computes univariate and multivariate Jarque-Bera tests
  and multivariate skewness and kurtosis tests for the residuals of a
  VAR(p) or of a VECM in levels. 
}

\usage{
normality.test(x, multivariate.only = TRUE)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}, or an object of class \sQuote{\code{vec2var}};
    generated by \command{vec2var()}.}
  \item{multivariate.only}{If \code{TRUE} (the default), only
    multivariate test statistics are computed.}
}

\details{
  Multivariate and univariate versions of the Jarque-Bera test are
  applied to the residuals of a VAR. The multivariate version of this
  test is computed by using the residuals that are standardized by a
  Choleski decomposition of the variance-covariance matrix for the centered
  residuals. Please note, that in this case the test result is dependant
  upon the ordering of the variables.
}

\value{
  A list of class \sQuote{\code{varcheck}} with the following elements is
  returned:\cr
  
  \item{resid}{A matrix of the residuals.}
  \item{jb.uni}{A list of elements with class attribute
    \sQuote{\code{htest}} containing the univariate Jarque-Bera
    tests. This element is only returned if \code{multivariate.only =
      FALSE} is set.}
  \item{jb.mul}{A list of elements with class attribute
    \sQuote{\code{htest}}.} containing the mutlivariate Jarque-Bera
  test, the multivariate Skewness and Kurtosis tests.    
}

\note{This function was named \code{normality} in earlier versions of package
  \pkg{vars}; it is now deprecated. See \code{\link{vars-deprecated}} too.
  }

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Jarque, C. M. and A. K. Bera (1987), A test for normality of
  observations and regression residuals, \emph{International Statistical
  Review}, \bold{55}: 163-172.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}, \code{\link{vec2var}}, \code{\link{plot}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
normality.test(var.2c)
}

\keyword{regression}
\concept{VAR}
\concept{VECM}
\concept{Vector autoregressive model}
\concept{Jarque-Bera}
\concept{Skewness}
\concept{Kurtosis}
\concept{Normality}


