% Generated by roxygen2 (4.0.1): do not edit by hand
\name{export_template}
\alias{export_template}
\title{Export a built-in script template}
\usage{
export_template(builtin = "template_en.R", to = "./template_en.R")
}
\arguments{
\item{builtin}{name of the built-in template. See details.}

\item{to}{path where the file have to be written}
}
\value{
Return the path where the file template was written. If there is an error, return FALSE.
}
\description{
Export to a file a built-in script template. This way it's possible to adapt it to user's needs. Basically, it's a wrapper for the \code{\link{file.copy}} function.
}
\details{
Actually, built-in templates are : \Sexpr{library(vartors);paste0(list_templates(), collapse = ", ")}
}
\examples{
# export the default built-in template
\dontrun{
export_template("template_to_edit.R", "en.R")
}
}
\author{
Joris Muller
}
\seealso{
\code{\link{import_template}}
}
\keyword{template}

