% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vchart.R
\name{vchart}
\alias{vchart}
\title{Create interactive charts with VChart}
\usage{
vchart(
  data = NULL,
  mapping = NULL,
  ...,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{Can be a \code{data.frame} if function used with other layers functions or a list of parameters for configuring a chart.}

\item{mapping}{Default list of aesthetic mappings to use for chart, only used if \code{data} is a \code{data.frame}.}

\item{...}{Additional parameters.}

\item{width}{Fixed width for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{height}{Fixed height for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{elementId}{Use an explicit element ID for the widget (rather than an
automatically generated one). Useful if you have other JavaScript that
needs to explicitly discover and interact with a specific widget instance.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
VChart is a charting component library, see more about it here : \url{https://www.visactor.io/vchart}.
}
\note{
This function allow you to use JavaScript function \code{VChart} directly,
see \url{https://www.visactor.io/vchart/option/} for how to specify options.
}
\examples{

library(vchartr)

# Use JS syntax to construct chart
vchart(
  type = "line",
  data = list(
    list(
      values = list(
        list(month = "January", value = 4.3),
        list(month = "February", value = 4.6),
        list(month = "March", value = 7.4),
        list(month = "April", value = 10.7),
        list(month = "May", value = 14.3),
        list(month = "June", value = 17.7),
        list(month = "July", value = 19.8),
        list(month = "August", value = 19.4),
        list(month = "September", value = 16.4),
        list(month = "October", value = 12.6),
        list(month = "November", value = 7.9),
        list(month = "December", value = 4.8)
      )
    )
  ),
  xField = "month",
  yField = "value",
  crosshair = list(
    xField = list(visible = TRUE)
  )
)

# or use R API
vchart(meteo_paris) \%>\%
  v_line(aes(month, temperature_avg)) \%>\%
  v_specs(
    crosshair = list(
      xField = list(visible = TRUE)
    )
  )

# or
vchart(meteo_paris, aes(month, temperature_avg)) \%>\%
  v_line() \%>\%
  v_specs(
    crosshair = list(
      xField = list(visible = TRUE)
    )
  )

# or
vchart() \%>\%
  v_line(aes(month, temperature_avg), data = meteo_paris) \%>\%
  v_specs(
    crosshair = list(
      xField = list(visible = TRUE)
    )
  )

}
