% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.odds}
\alias{meta.ave.odds}
\title{Confidence interval for average odds ratio from 2-group studies}
\usage{
meta.ave.odds(alpha, f1, f2, n1, n2, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 frequency counts}

\item{f2}{vector of group 2 frequency counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - the exponentiated estimate
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
geometric average odds ratio from two or more studies.
}
\examples{
n1 <- c(204, 201, 932, 130, 77)
n2 <- c(106, 103, 415, 132, 83)
f1 <- c(24, 40, 93, 14, 5)
f2 <- c(12, 9, 28, 3, 1)
meta.ave.odds(.05, f1, f2, n1, n2, bystudy = TRUE)

# Should return:
#           Estimate        SE          LL        UL 
# Average 0.86211102 0.2512852  0.36960107 1.3546210
# Study 1 0.02581353 0.3700520 -0.69947512 0.7511022
# Study 2 0.91410487 0.3830515  0.16333766 1.6648721
# Study 3 0.41496672 0.2226089 -0.02133877 0.8512722
# Study 4 1.52717529 0.6090858  0.33338907 2.7209615
# Study 5 1.42849472 0.9350931 -0.40425414 3.2612436
#         exp(Estimate)   exp(LL)   exp(UL)
# Average      2.368155 1.4471572  3.875292
# Study 1      1.026150 0.4968460  2.119335
# Study 2      2.494541 1.1774342  5.284997
# Study 3      1.514320 0.9788873  2.342625
# Study 4      4.605150 1.3956902 15.194925
# Study 5      4.172414 0.6674745 26.081952


}
\references{
\insertRef{Bonett2015}{vcmeta}
}
