% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.prop2}
\alias{meta.lc.prop2}
\title{Confidence interval for a linear contrast of proportion differences in 2-group studies}
\usage{
meta.lc.prop2(alpha, f1, f2, n1, n2, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{vector of group 1 frequency counts}

\item{f2}{vector of group 2 frequency counts}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the following columns:
\itemize{
\item Estimate - estimate of the linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
linear contrast of 2-group proportion differences from two or more studies.
}
\examples{
n1 <- c(50, 150, 150)
n2 <- c(50, 150, 150)
f1 <- c(16, 50, 25)
f2 <- c(7, 15, 20)
v <- c(1, -1, 0)
meta.lc.prop2(.05, f1, f2, n1, n2, v)

# Should return:
#             Estimate         SE         LL        UL
# Contrast -0.05466931 0.09401019 -0.2389259 0.1295873


}
\references{
\insertRef{Bonett2014}{vcmeta}
}
