% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.stdmean2}
\alias{replicate.stdmean2}
\title{Compares and combines 2-group standardized mean differences in original and
follow-up studies}
\usage{
replicate.stdmean2(
  alpha,
  m11,
  m12,
  sd11,
  sd12,
  n11,
  n12,
  m21,
  m22,
  sd21,
  sd22,
  n21,
  n22
)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m11}{estimated mean for group 1 in original study}

\item{m12}{estimated mean for group 2 in original study}

\item{sd11}{estimated SD for group 1 in original study}

\item{sd12}{estimated SD for group 2 in original study}

\item{n11}{sample size for group 1 in original study}

\item{n12}{sample size for group 2 in original study}

\item{m21}{estimated mean for group 1 in follow-up study}

\item{m22}{estimated mean for group 2 in follow-up study}

\item{sd21}{estimated SD for group 1 in follow-up study}

\item{sd22}{estimated SD for group 2 in follow-up study}

\item{n21}{sample size for group 1 in follow-up study}

\item{n22}{sample size for group 2 in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference between studies
\item Row 4 estimates the average effect size for the two studies
}

The columns are:
\itemize{
\item Estimate - standardized mean difference estimate (single study, difference, average)
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function computes confidence intervals for a 2-group standardized mean
difference from an original study and a follow-up study. Confidence intervals
for the difference and average effect size also are computed. The same results
can be obtained using the \link[vcmeta]{meta.lc.stdmean2} function with
appropriate contrast coefficients. The confidence level for the difference is
1 – 2alpha.
}
\examples{
replicate.stdmean2(.05, 21.9, 16.1, 3.82, 3.21, 40, 40, 
                        25.2, 19.1, 3.98, 3.79, 75, 75)

# Should return: 
#                           Estimate        SE         LL        UL
#  Original:              1.62803662 0.2594668  1.1353486 2.1524396
#  Follow-up:             1.56170447 0.1870576  1.2030461 1.9362986
#  Original - Follow-up:  0.07422178 0.3198649 -0.4519092 0.6003527
#  Average:               1.59487055 0.1599325  1.2814087 1.9083324


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
