% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.sub.gen}
\alias{meta.sub.gen}
\title{Confidence interval for a subgroup difference in average effect size}
\usage{
meta.sub.gen(alpha, est, se, group)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{est}{vector of estimated effect sizes}

\item{se}{vector of effect size standard errors}

\item{group}{vector of group indicators:
\itemize{
\item 1 for set A
\item 2 for set B
\item 0 to ignore
}}
}
\value{
Returns a matrix with three rows:
\itemize{
\item Row 1 - estimate for Set A
\item Row 2 - estimate for Set B
\item Row 3 - estimate for difference, Set A - Set B
}

The columns are:
\itemize{
\item Estimate - estimated average effect size or difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
difference in the average effect size (any type of effect size) for
two mutually exclusive subgroups of studies. Each subgroup can have one
or more studies. All of the effects sizes should be compatible.
}
\examples{
est <- c(.920, .896, .760, .745)
se <- c(.098, .075, .069, .055) 
group <- c(1, 1, 2, 2)
meta.sub.gen(.05, est, se, group)

# Should return:
#                Estimate         SE          LL        UL
# Set A:           0.9080 0.06170292 0.787064504 1.0289355
# Set B:           0.7525 0.04411916 0.666028042 0.8389720
# Set A - Set B:   0.1555 0.07585348 0.006829917 0.3041701


}
