% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_handler.R
\docType{data}
\name{RequestHandler}
\alias{RequestHandler}
\title{RequestHandler}
\arguments{
\item{request}{The request from an object of class \code{HttpInteraction}}
}
\description{
RequestHandler
}
\details{
\strong{Public Methods}
\describe{
\item{\code{handle(request)}}{
Top level function to interaction with. Handle the request
}
}

\strong{Private Methods}
\describe{
\item{\code{request_type(request)}}{
Get the request type
}
\item{\code{externally_stubbed()}}{
just returns FALSE
}
\item{\code{should_ignore()}}{
should we ignore the request, depends on request ignorer
infrastructure that's not working yet
}
\item{\code{has_response_stub()}}{
Check if there is a matching response stub in the
http interaction list
}
\item{\code{get_stubbed_response()}}{
Check for a response and get it
}
\item{\code{request_summary(request)}}{
get a request summary
}
\item{\code{on_externally_stubbed_request(request)}}{
on externally stubbed request do nothing
}
\item{\code{on_ignored_request(request)}}{
on ignored request, do something
}
\item{\code{on_recordable_request(request)}}{
on recordable request, record the request
}
\item{\code{on_unhandled_request(request)}}{
on unhandled request, run UnhandledHTTPRequestError
}
}
}
\examples{
\dontrun{
# record mode: once
vcr_configure(
 dir = tempdir(),
 record = "once"
)

data(crul_request)
crul_request$url$handle <- curl::new_handle()
crul_request
x <- RequestHandler$new(crul_request)
# x$handle()

# record mode: none
vcr_configure(
 dir = tempdir(),
 record = "none"
)
data(crul_request)
crul_request$url$handle <- curl::new_handle()
crul_request
insert_cassette("testing_record_mode_none", record = "none")
file.path(vcr_c$dir, "testing_record_mode_none.yml")
x <- RequestHandlerCrul$new(crul_request)
# x$handle()
crul_request$url$url <- "https://api.crossref.org/works/10.1039/c8sm90002g/"
crul_request$url$handle <- curl::new_handle()
z <- RequestHandlerCrul$new(crul_request)
# z$handle()
eject_cassette("testing_record_mode_none")
}
}
\keyword{datasets}
