% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-data-frame.R
\name{new_data_frame}
\alias{new_data_frame}
\title{Assemble attributes for data frame construction}
\usage{
new_data_frame(x = list(), n = NULL, ..., class = NULL)
}
\arguments{
\item{x}{A named list of equal-length vectors. The lengths are not
checked; it is responsibility of the caller to make sure they are
equal.}

\item{n}{Number of rows. If \code{NULL}, will be computed from the length of
the first element of \code{x}.}

\item{..., class}{Additional arguments for creating subclasses.
The \code{"names"} and \code{"row.names"} attributes override input in \code{x} and \code{n},
respectively:
\itemize{
\item \code{"names"} is used if provided, overriding existing names in \code{x}
\item \code{"row.names"} is used if provided, if \code{n} is provided it must be
consistent.
}}
}
\description{
\code{new_data_frame()} constructs a new data frame from an existing list. It is
meant to be performant, and does not check the inputs for correctness in any
way. It is only safe to use after a call to \code{\link[=df_list]{df_list()}}, which collects and
validates the columns used to construct the data frame.
}
\examples{
new_data_frame(list(x = 1:10, y = 10:1))
}
\seealso{
\code{\link[=df_list]{df_list()}} for a way to safely construct a data frame's underlying
data structure from individual columns. This can be used to create a
named list for further use by \code{new_data_frame()}.
}
