% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-version.R
\name{vega_schema}
\alias{vega_schema}
\title{Create string for schema-URL}
\usage{
vega_schema(library = c("vega_lite", "vega"), major = TRUE)
}
\arguments{
\item{library}{\code{character}, either \code{"vega"} or \code{"vega_lite"}}

\item{major}{\code{logical} return major version-tags rather than the
tags for the specific versions supported by this package}
}
\value{
\code{character} URL for schema
}
\description{
Useful if you are creating a vegaspec manually.
}
\examples{
  vega_schema()
  vega_schema("vega", major = FALSE)

  # creating a spec by hand
  spec <-
    list(
      `$schema` = vega_schema(),
      width = 300,
      height = 300
      # and so on
    ) \%>\%
    as_vegaspec()

}
