% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_ldv_speed.R
\name{ef_ldv_speed}
\alias{ef_ldv_speed}
\title{Emissions factors for Light Duty Vehicles and Motorcycles}
\usage{
ef_ldv_speed(v, t, cc, f, eu, p, k = 1, show.equation = TRUE)
}
\arguments{
\item{v}{Category vehicle: "PC", "LCV", "Motorcycle" or "Moped}

\item{t}{Sub-category of of vehicle: "PRE_ECE", "ECE_1501", "ECE_1502",
"ECE_1503", "ECE_1504" , "IMPROVED_CONVENTIONAL", "OPEN_LOOP", "ALL",
"2S"  or "4S"}

\item{cc}{Size of engine in cc: "ALL", "<=1400", ">1400", "1400_2000", ">2000",
"<=800", "800_1400", "<=2000", "2S", "<=50", ">=50", "<=250", "250_750", ">=750",
or ">50"}

\item{f}{Type of fuel: "G", "D", "LPG" or "FH" (Full Hybrid: starts by electric motor)}

\item{eu}{Euro standard: "PRE", "I", "II", "III", "III+DPF", "IV", "V", "VI", "VIc"
or "ALL"}

\item{p}{Pollutant: "CO", "FC", "NOx", "HC" or "PM"}

\item{k}{Multiplication factor}

\item{show.equation}{Option to see or not the equation parameters}
}
\value{
an emission factor function which depends of the average speed V  g/km
}
\description{
This function returns speed dependent emission factors. The emission factors
 comes from the guidelines  EMEP/EEA air pollutant emission inventory guidebook
http://www.eea.europa.eu/themes/air/emep-eea-air-pollutant-emission-inventory-guidebook
}
\details{
The argument of this functions have several options which results in
different combinations that returns emission factors. If a combination of
any option is wrong it will return an empty value. Therefore, it is
important ti know the combinations.
}
\examples{
\dontrun{
# Do not run
V <- 0:150
ef1 <- ef_ldv_speed(v = "PC",t = "PRE_ECE", cc = "ALL", f = "G", eu = "PRE", p = "CO")
plot(1:150, ef1(1:150))
}
}
\keyword{emission}
\keyword{factors}
\keyword{speed}
