% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_moto.R
\name{age_moto}
\alias{age_moto}
\title{Returns amount of vehicles at each age}
\usage{
age_moto(x, name = "age", a = 0.2, b = 17, agemin = 1,
  agemax = 50, k = 1, bystreet = F, net, message = TRUE)
}
\arguments{
\item{x}{Numeric; numerical vector of vehicles with length equal to lines features of raod network}

\item{name}{Character; of vehicle assigned to columns of dataframe}

\item{a}{Numeric; parameter of survival equation}

\item{b}{Numeric; parameter of survival equation}

\item{agemin}{Integer; age of newest vehicles for that category}

\item{agemax}{Integer; age of oldest vehicles for that category}

\item{k}{Integer; multiplication factor. If its length is > 1, it must match the length of x}

\item{bystreet}{Logical; when TRUE it is expecting that 'a' and 'b' are numeric vectors with length equal to x}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{message}{Logical;  message with average age and total numer of vehicles}
}
\value{
dataframe of age distrubution of vehicles
}
\description{
\code{\link{age_moto}} returns amount of vehicles at each age
}
\examples{
{
data(net)
MOTO_E25_500 <- age_moto(x = net$ldv, name = "M_E25_500", k = 0.4)
plot(MOTO_E25_500)
MOTO_E25_500 <- age_moto(x = net$ldv, name = "M_E25_500", k = 0.4, net = net)
plot(MOTO_E25_500)
}
}
