% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speciate.R
\name{speciate}
\alias{speciate}
\title{Speciation of emissions}
\usage{
speciate(
  x = 1,
  spec = "bcom",
  veh,
  fuel,
  eu,
  list = FALSE,
  pmpar,
  verbose = FALSE
)
}
\arguments{
\item{x}{Emissions estimation}

\item{spec}{The speciations are:
\itemize{
\item{"bcom"}{: Splits PM2.5 in black carbon and organic matter.}
\item{"tyre" or "tire"}{: Splits PM in PM10, PM2.5, PM1 and PM0.1.}
\item{"brake"}{: Splits PM in PM10, PM2.5, PM1 and PM0.1.}
\item{"road"}{: Splits PM in PM10 and PM2.5.}
\item{"nox"}{: Splits NOx in NO and NO2.}
\item{"nmhc"}{: Splits NMHC in compounds, see \code{\link{ef_ldv_speed}}.}
\item{"pmiag", "pmneu",  "pmneu2"}{: Splits PM in groups, see note below.}
}
The following still available but they will be removed soon:
\itemize{
\item{"iag_racm"}{: ethanol emissions added in hc3.}
\item{"iag" or "iag_cb05"}{: Splits NMHC by CB05 (WRF exb05_opt1) group .}
\item{"petroiag_cb05"}{: Splits NMHC by CB05 (WRF exb05_opt1) group .}
\item{"iag_cb05v2"}{: Splits NMHC by CB05 (WRF exb05_opt2) group .}
\item{"neu_cb05"}{: Splits NMHC by CB05 (WRF exb05_opt2) group alternative.}
\item{"petroiag_cb05v2"}{: Splits NMHC by CB05 (WRF exb05_opt2) group alternative.}
}}

\item{veh}{Type of vehicle:
\itemize{
\item{"bcom"}{: veh can be "PC", "LCV", HDV" or "Motorcycle".}
\item{"tyre" or "tire"}{: not necessary.}
\item{"brake"}{: not necessary.}
\item{"road"}{: not necessary.}
\item{"nox"}{: veh can be "PC", "LCV", HDV" or "Motorcycle".}
\item{"nmhc"}{: veh can be "LDV", "HDV" or "LPG".}
\item{""pmiag", "pmneu",  "pmneu2"}{: not necessary.}
}
#' The following still available but they will be removed soon:
\itemize{
\item{"iag_racm"}{: veh accepts "veh".}
\item{"iag" or "iag_cb05"}{: veh accepts "veh" .}
\item{"iag_cb05v2"}{: veh accepts "veh" .}
\item{"neu_cb05"}{: veh accepts "veh" .}
\item{"petroiag_cb05"}{: veh accepts "veh" .}
\item{"petroiag_cb05v2"}{: veh accepts "veh" .}
}}

\item{fuel}{Fuel.
\itemize{
\item{"bcom"}{: "G" or "D".}
\item{"tyre" or "tire"}{: not necessary.}
\item{"brake"}{: not necessary.}
\item{"road"}{: not necessary.}
\item{"nox"}{: "G", "D", "LPG", "E85" or "CNG".}
\item{"nmhc"}{: "G", "D" or "LPG".}
\item{"pmiag", "pmneu",  "pmneu2"}{: not necessary.}
}
#' The following still available but they will be removed soon:
\itemize{
\item{"iag_racm"}{: "G", "E" or "D".}
\item{"iag" or "iag_cb05"}{: "G", "E" or "D".}
\item{"iag_cb05v2"}{: "G", "E" or "D".}
\item{"neu_cb05"}{: "G", "E" or "D".}
\item{"petroiag_cb05"}{: "G", "E" or "D".}
\item{"petroiag_cb05v2"}{: "G", "E" or "D".}
}}

\item{eu}{Emission standard
\itemize{
\item{"bcom"}{: "G" or "D".}
\item{"tyre" or "tire"}{: not necessary.}
\item{"brake"}{: not necessary.}
\item{"road"}{: not necessary.}
\item{"nox"}{: "G", "D", "LPG", "E85" or "CNG".}
\item{"nmhc"}{: "PRE", "ECE_1501", "ECE_1502", "ECE_1503","I", "II",
"III", "IV",  "V", "III-CDFP","IV-CDFP","V-CDFP", "III-ADFP",
"IV-ADFP","V-ADFP" or "OPEN_LOOP". eu can be "ALL" if spec is "nmhc" and
fuel is "LPG"}
\item{"pmiag", "pmneu",  "pmneu2"}{: not necessary.}
}
#' The following still available but they will be removed soon:
\itemize{
\item{"iag_racm"}{: "Exhaust", "Evaporative" or "Liquid".}
\item{"iag" or "iag_cb05"}{: "Exhaust", "Evaporative" or "Liquid".}
\item{"iag_cb05v2"}{: "Exhaust", "Evaporative" or "Liquid".}
\item{"neu_cb05"}{: "Exhaust", "Evaporative" or "Liquid".}
\item{"petroiag_cb05"}{: "Exhaust", "Evaporative" or "Liquid".}
\item{"petroiag_cb05v2"}{: "Exhaust", "Evaporative" or "Liquid".}
}}

\item{list}{when TRUE returns a list with number of elements of the list as
the number species of pollutants}

\item{pmpar}{Numeric vector for PM speciation eg:
c(e_so4i = 0.0077,  e_so4j = 0.0623,  e_no3i = 0.00247,
e_no3j = 0.01053,  e_pm25i = 0.1,  e_pm25j = 0.3,
e_orgi = 0.0304,  e_orgj = 0.1296,  e_eci = 0.056,
e_ecj = 0.024,  h2o = 0.277) These are default values. however, when this
argument is present, new values are used.}

\item{verbose}{Logical to show more information}
}
\value{
dataframe of speciation in grams or mols
}
\description{
\code{speciate} separates emissions in different compounds.
It covers black carbon and organic matter from particulate matter. Soon it
will be added more speciations
}
\note{
spec \strong{"pmiag"} speciate pm2.5 into e_so4i, e_so4j, e_no3i,
e_no3j, e_mp2.5i, e_mp2.5j, e_orgi, e_orgj, e_eci, e_ecj and h2o. Reference:
Rafee, S.: Estudo numerico do impacto das emissoes veiculares e fixas da
cidade de Manaus nas concentracoes de poluentes atmosfericos da regiao
amazonica, Master thesis, Londrina: Universidade Tecnologica Federal do
Parana, 2015.

specs: "neu_cb05", "pmneu" and "pmneu2" provided by Daniel Schuch,
from Northeastern University

Speciation with fuels \strong{"E25", "E100" and "B5"} made by Prof. Leila Martins (UTFPR),
represents BRAZILIAN fuel


pmiag2 pass the mass only on j fraction
}
\examples{
\dontrun{
# Do not run
pm <- rnorm(n = 100, mean = 400, sd = 2)
(df <- speciate(pm, veh = "PC", fuel = "G", eu = "I"))
(df <- speciate(pm, spec = "brake", veh = "PC", fuel = "G", eu = "I"))
(dfa <- speciate(pm, spec = "iag", veh = "veh", fuel = "G", eu = "Exhaust"))
(dfb <- speciate(pm, spec = "iag_cb05v2", veh = "veh", fuel = "G", eu = "Exhaust"))
(dfb <- speciate(pm, spec = "neu_cb05", veh = "veh", fuel = "G", eu = "Exhaust"))
pm <- units::set_units(pm, "g/km^2/h")
#(dfb <- speciate(as.data.frame(pm), spec = "pmiag", veh = "veh", fuel = "G", eu = "Exhaust"))
#(dfb <- speciate(as.data.frame(pm), spec = "pmneu", veh = "veh", fuel = "G", eu = "Exhaust"))
#(dfb <- speciate(as.data.frame(pm), spec = "pmneu2", veh = "veh", fuel = "G", eu = "Exhaust"))
# new
(pah <- speciate(spec = "pah", veh = "LDV", fuel = "G", eu = "I"))
(xs <- speciate(spec = "pcdd", veh = "LDV", fuel = "G", eu = "I"))
(xs <- speciate(spec = "pmchar", veh = "LDV", fuel = "G", eu = "I"))
(xs <- speciate(spec = "metals", veh = "LDV", fuel = "G", eu = "all"))
}
}
\references{
"bcom": Ntziachristos and Zamaras. 2016. Passenger cars, light
commercial trucks, heavy-duty vehicles including buses and motorcycles. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2016

"tyre", "brake" and "road": Ntziachristos and Boulter 2016.
Automobile tyre and brake wear and road abrasion. In: EEA, EMEP. EEA air
pollutant emission inventory
guidebook-2009. European Environment Agency, Copenhagen, 2016

"iag": Ibarra-Espinosa S. Air pollution modeling in Sao Paulo
using bottom-up vehicular emissions inventories. 2017. PhD thesis. Instituto de
Astronomia, Geofisica e Ciencias Atmosfericas, Universidade de Sao Paulo,
Sao Paulo, page 88.
Speciate EPA: https://cfpub.epa.gov/speciate/. :
K. Sexton, H. Westberg, "Ambient hydrocarbon and ozone measurements downwind
of a large automotive painting plant" Environ. Sci. Tchnol. 14:329 (1980).P.A.
Scheff, R.A. Schauer, James J., Kleeman, Mike J., Cass, Glen R., Characterization
and Control of Organic Compounds Emitted from Air Pollution Sources, Final Report,
Contract 93-329, prepared for California Air Resources Board Research Division,
Sacramento, CA, April 1998.
2004 NPRI National Databases as of April 25, 2006,
http://www.ec.gc.ca/pdb/npri/npri_dat_rep_e.cfm. Memorandum
Proposed procedures for preparing composite speciation profiles using
Environment Canada s National Pollutant Release Inventory (NPRI) for
stationary sources, prepared by Ying Hsu and Randy Strait of E.H. Pechan
Associates, Inc. for David Niemi, Marc Deslauriers, and Lisa Graham of
Environment Canada, September 26, 2006.
}
