% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Speed.R
\name{Speed}
\alias{Speed}
\alias{print.Speed}
\alias{summary.Speed}
\alias{plot.Speed}
\title{Construction function for class "Speed"}
\usage{
Speed(x, ..., dist = "km", time = "h")

\method{print}{Speed}(x, ...)

\method{summary}{Speed}(object, ...)

\method{plot}{Speed}(
  x,
  pal = "mpl_inferno",
  rev = FALSE,
  fig1 = c(0, 0.8, 0, 0.8),
  fig2 = c(0, 0.8, 0.55, 1),
  fig3 = c(0.7, 1, 0, 0.8),
  mai1 = c(1, 0.82, 0.82, 0.42),
  mai2 = c(1.8, 0.82, 0.5, 0.42),
  mai3 = c(1, 1, 0.82, 0.2),
  bias = 1.5,
  ...
)
}
\arguments{
\item{x}{Object with class "data.frame", "matrix" or "numeric"}

\item{...}{ignored
Default is units is "km"}

\item{dist}{String indicating the units of the resulting distance in speed.}

\item{time}{Character to be the time units as denominator, default is "h"}

\item{object}{Object with class "Speed"}

\item{pal}{Palette of colors available or the number of the position}

\item{rev}{Logical; to internally revert order of rgb color vectors.}

\item{fig1}{par parameters for fig, \code{\link{par}}.}

\item{fig2}{par parameters for fig, \code{\link{par}}.}

\item{fig3}{par parameters for fig, \code{\link{par}}.}

\item{mai1}{par parameters for mai, \code{\link{par}}.}

\item{mai2}{par parameters for mai, \code{\link{par}}.}

\item{mai3}{par parameters for mai, \code{\link{par}}.}

\item{bias}{positive number. Higher values give more widely spaced colors at the high end.}
}
\value{
Constructor for class "Speed" or "units"
}
\description{
\code{Speed} returns a transformed object with class "Speed" and units
 km/h. This function includes two arguments, distance and time. Therefore,
 it is possible to change the units of the speed to "m" to "s" for example.
 This function returns a data.frame with units for speed. When this function
 is applied to numeric vectors it adds class "units".
}
\note{
default time unit for speed is hour
}
\examples{
{
data(net)
data(pc_profile)
speed <- Speed(net$ps)
class(speed)
plot(speed, type = "l")
pc_week <- temp_fact(net$ldv+net$hdv, pc_profile)
df <- netspeed(pc_week, net$ps, net$ffs, net$capacity, net$lkm)
summary(df)
plot(df)
# changing to miles
net$ps <- units::set_units(net$ps, "miles/h")
net$ffs <- units::set_units(net$ffs, "miles/h")
net$lkm <- units::set_units(net$lkm, "miles")
df <- netspeed(pc_week, net$ps, net$ffs, net$capacity, net$lkm, dist = "miles")
plot(df)
}
}
\seealso{
\code{\link{units}}
}
