% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speciate.R
\name{speciate}
\alias{speciate}
\title{Speciation of emissions}
\usage{
speciate(
  x = 1,
  spec = "bcom",
  veh,
  fuel,
  eu,
  list = FALSE,
  pmpar,
  verbose = FALSE
)
}
\arguments{
\item{x}{Emissions estimation}

\item{spec}{The speciations are:
\itemize{
\item "bcom": Splits PM2.5 in black carbon and organic matter.
\item "tyre" or "tire": Splits PM in PM10, PM2.5, PM1 and PM0.1.
\item "brake": Splits PM in PM10, PM2.5, PM1 and PM0.1.
\item "road": Splits PM in PM10 and PM2.5.
\item "nox": Splits NOx in NO and NO2.
\item "nmhc": Splits NMHC in compounds, see \code{\link{ef_ldv_speed}}.
\item "voc": Splits NMHC in voc groups according EDGAR-CAMS.
\item "pmiag", "pmneu",  "pmneu2", "pm2023": Splits PM in groups, see note below.
}}

\item{veh}{Type of vehicle:
\itemize{
\item "bcom": veh can be "PC", "LCV", HDV" or "Motorcycle".
\item "tyre" or "tire": not necessary.
\item "brake": not necessary.
\item "road": not necessary.
\item "nox": veh can be "PC", "LCV", HDV" or "Motorcycle".
\item "nmhc":see below
\item "voc": read options while running.
\item ""pmiag", "pmneu",  "pmneu2", "pm2023": not necessary.
}}

\item{fuel}{Fuel.
\itemize{
\item "bcom": "G" or "D".
\item "tyre" or "tire": not necessary.
\item "brake": not necessary.
\item "road": not necessary.
\item "nox": "G", "D", "LPG", "E85" or "CNG".
\item "nmhc":see below
\item "voc": read options while running.
\item "pmiag", "pmneu",  "pmneu2", "pm2023": not necessary.
}}

\item{eu}{Emission standard
\itemize{
\item "bcom": "G" or "D".
\item "tyre" or "tire": not necessary.
\item "brake": not necessary.
\item "road": not necessary.
\item "nox": "G", "D", "LPG", "E85" or "CNG".
\item "nmhc":see below
\item "voc": read options while running.
\item "pmiag", "pmneu",  "pmneu2", "pm2023": not necessary.
}}

\item{list}{when TRUE returns a list with number of elements of the list as
the number species of pollutants}

\item{pmpar}{Numeric vector for PM speciation eg:
c(e_so4i = 0.0077,  e_so4j = 0.0623,  e_no3i = 0.00247,
e_no3j = 0.01053,  e_pm25i = 0.1,  e_pm25j = 0.3,
e_orgi = 0.0304,  e_orgj = 0.1296,  e_eci = 0.056,
e_ecj = 0.024,  h2o = 0.277) These are default values. however, when this
argument is present, new values are used.}

\item{verbose}{Logical to show more information}
}
\value{
dataframe of speciation in grams or mols
}
\description{
\code{speciate} separates emissions in different compounds.
It covers black carbon and organic matter from particulate matter. Soon it
will be added more speciations
}
\note{
options for spec "nmhc":
\tabular{ccc}{
   veh \tab fuel \tab eu          \cr
   LDV \tab G    \tab PRE         \cr
   LDV \tab G    \tab I           \cr
   LDV \tab D    \tab all         \cr
   HDV \tab D    \tab all         \cr
   LDV \tab LPG  \tab all         \cr
   LDV \tab G    \tab Evaporative \cr
   LDV \tab E25  \tab Evaporative \cr
   LDV \tab E100 \tab Evaporative \cr
   LDV \tab E25  \tab Exhaust     \cr
   LDV \tab E100 \tab Exhaust     \cr
   HDV \tab B5   \tab Exhaust     \cr
   LDV \tab E85  \tab Exhaust     \cr
   LDV \tab E85  \tab Evaporative \cr
   LDV \tab CNG  \tab Exhaust     \cr
   ALL \tab E100 \tab Liquid      \cr
   ALL \tab G    \tab Liquid      \cr
   ALL \tab E25  \tab Liquid      \cr
   ALL \tab ALL  \tab OM          \cr
   LDV \tab G    \tab OM-001      \cr
   LDV \tab D    \tab OM-002      \cr
   HDV \tab D    \tab OM-003      \cr
   MC  \tab G    \tab OM-004      \cr
   ALL  \tab LPG \tab OM-005      \cr
   LDV \tab G    \tab OM-001-001  \cr
   LDV \tab G    \tab OM-001-002  \cr
   LDV \tab G    \tab OM-001-003  \cr
   LDV \tab G    \tab OM-001-004  \cr
   LDV \tab G    \tab OM-001-005  \cr
   LDV \tab G    \tab OM-001-006  \cr
   LDV \tab G    \tab OM-001-007  \cr
   LDV \tab D    \tab OM-002-001  \cr
   LDV \tab D    \tab OM-002-002  \cr
   LDV \tab D    \tab OM-002-003  \cr
   LDV \tab D    \tab OM-002-004  \cr
   LDV \tab D    \tab OM-002-005  \cr
   LDV \tab D    \tab OM-002-006  \cr
   HDV \tab D    \tab OM-003-001  \cr
   HDV \tab D    \tab OM-003-002  \cr
   HDV \tab D    \tab OM-003-003  \cr
   HDV \tab D    \tab OM-003-004  \cr
   HDV \tab D    \tab OM-003-005  \cr
   HDV \tab D    \tab OM-003-006  \cr
   MC  \tab G    \tab OM-004-001  \cr
   MC  \tab G    \tab OM-004-002  \cr
   MC  \tab G    \tab OM-004-003  \cr
   ALL  \tab ALL    \tab urban  \cr
   ALL  \tab ALL    \tab highway  \cr
}

after eu = OM, all profiles are Chinese
# the following specs will be removed soon
\itemize{
\item"iag_racm": ethanol emissions added in hc3.
\item"iag" or "iag_cb05": Splits NMHC by CB05 (WRF exb05_opt1) group .
\item"petroiag_cb05": Splits NMHC by CB05 (WRF exb05_opt1) group .
\item"iag_cb05v2": Splits NMHC by CB05 (WRF exb05_opt2) group .
\item"neu_cb05": Splits NMHC by CB05 (WRF exb05_opt2) group alternative.
\item"petroiag_cb05v2": Splits NMHC by CB05 (WRF exb05_opt2) group alternative.
}

spec \strong{"pmiag"} speciate pm2.5 into e_so4i, e_so4j, e_no3i,
e_no3j, e_mp2.5i, e_mp2.5j, e_orgi, e_orgj, e_eci, e_ecj and h2o. Reference:
Rafee, S.: Estudo numerico do impacto das emissoes veiculares e fixas da
cidade de Manaus nas concentracoes de poluentes atmosfericos da regiao
amazonica, Master thesis, Londrina: Universidade Tecnologica Federal do
Parana, 2015.

specs: "neu_cb05", "pmneu" and "pmneu2" provided by Daniel Schuch,
from Northeastern University.
"pm2023" provided by Iara da Silva; Leila D. Martins

Speciation with fuels \strong{"E25", "E100" and "B5"} made by Prof. Leila Martins (UTFPR),
represents BRAZILIAN fuel


pmiag2 pass the mass only on j fraction

spec \strong{"voc"} splits nmhc into the 25 VOC
groups according: Huang et al 2019, "Speciation of anthropogenic
emissions of non-methane volatile
organic compounds: a global gridded data set for
1970-2012" ACP. Speciation In development.
}
\examples{
\dontrun{
# Do not run
pm <- rnorm(n = 100, mean = 400, sd = 2)
(df <- speciate(pm, veh = "PC", fuel = "G", eu = "I"))
(df <- speciate(pm, spec = "brake", veh = "PC", fuel = "G", eu = "I"))
(dfa <- speciate(pm, spec = "iag", veh = "veh", fuel = "G", eu = "Exhaust"))
(dfb <- speciate(pm, spec = "iag_cb05v2", veh = "veh", fuel = "G", eu = "Exhaust"))
(dfb <- speciate(pm, spec = "neu_cb05", veh = "veh", fuel = "G", eu = "Exhaust"))
pm <- units::set_units(pm, "g/km^2/h")
#(dfb <- speciate(as.data.frame(pm), spec = "pmiag", veh = "veh", fuel = "G", eu = "Exhaust"))
#(dfb <- speciate(as.data.frame(pm), spec = "pmneu", veh = "veh", fuel = "G", eu = "Exhaust"))
#(dfb <- speciate(as.data.frame(pm), spec = "pmneu2", veh = "veh", fuel = "G", eu = "Exhaust"))
# new
(pah <- speciate(spec = "pah", veh = "LDV", fuel = "G", eu = "I"))
(xs <- speciate(spec = "pcdd", veh = "LDV", fuel = "G", eu = "I"))
(xs <- speciate(spec = "pmchar", veh = "LDV", fuel = "G", eu = "I"))
(xs <- speciate(spec = "metals", veh = "LDV", fuel = "G", eu = "all"))
}
}
\references{
"bcom": Ntziachristos and Zamaras. 2016. Passenger cars, light
commercial trucks, heavy-duty vehicles including buses and motorcycles. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2016

"tyre", "brake" and "road": Ntziachristos and Boulter 2016.
Automobile tyre and brake wear and road abrasion. In: EEA, EMEP. EEA air
pollutant emission inventory
guidebook-2009. European Environment Agency, Copenhagen, 2016

"iag": Ibarra-Espinosa S. Air pollution modeling in Sao Paulo
using bottom-up vehicular emissions inventories. 2017. PhD thesis. Instituto de
Astronomia, Geofisica e Ciencias Atmosfericas, Universidade de Sao Paulo,
Sao Paulo, page 88.
Speciate EPA: https://cfpub.epa.gov/speciate/. :
K. Sexton, H. Westberg, "Ambient hydrocarbon and ozone measurements downwind
of a large automotive painting plant" Environ. Sci. Tchnol. 14:329 (1980).P.A.
Scheff, R.A. Schauer, James J., Kleeman, Mike J., Cass, Glen R., Characterization
and Control of Organic Compounds Emitted from Air Pollution Sources, Final Report,
Contract 93-329, prepared for California Air Resources Board Research Division,
Sacramento, CA, April 1998.
2004 NPRI National Databases as of April 25, 2006,
http://www.ec.gc.ca/pdb/npri/npri_dat_rep_e.cfm. Memorandum
Proposed procedures for preparing composite speciation profiles using
Environment Canada s National Pollutant Release Inventory (NPRI) for
stationary sources, prepared by Ying Hsu and Randy Strait of E.H. Pechan
Associates, Inc. for David Niemi, Marc Deslauriers, and Lisa Graham of
Environment Canada, September 26, 2006.
}
