% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cullMatrix.R
\name{cullMatrix}
\alias{cullMatrix}
\alias{cullMatrix,errorMatrix,culltaxa,cullSamples,occurrencesFlag,diversityFlag,softCull,softTaxa,softSamples}
\title{Cull rare taxa and depauperate samples}
\usage{
cullMatrix(CommunityMatrix, Rarity = 2, Richness = 2, Silent = FALSE)
}
\arguments{
\item{CommunityMatrix}{a matrix}

\item{Rarity}{a whole number}

\item{Richness}{a whole number}

\item{Silent}{logical}
}
\value{
A community matrix with depauperate samples and rare taxa removed.
}
\description{
Functions for recursively culling community matrices of rare taxa and depauperate samples.
}
\details{
Takes a community matrix (see \code{presenceMatrix} or \code{abundanceMatrix}) and removes all samples with fewer than a certain number of taxa and all taxa that occur below a certain threshold of samples. The function operates recursively, and will check to see if removing a rare taxon drops a sampe below the input minimum richness and vice-versa. This means that it is possible to eliminate all taxa and samples if the rarity and richness minimums are too high. If the \code{Silent} argument is set to \code{FALSE} the function will throw an error and print a warning if no taxa or samples are left after culling. If \code{Silent} is set to \code{TRUE} the function will simply return \code{NULL}. The latter case is useful if many matrices are being culled as a part of a loop, and you do not want to break the loop with an error.

These functions originally appeared in the R script appendix of Holland, S.M. and A. Zaffos (2011) "Niche conservatism along an onshore-offshore gradient". \emph{Paleobiology} 37:270-286.
}
\examples{
# Download a test dataset of pleistocene bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Pleistocene",StopInterval="Pleistocene")

# Create a community matrix with tectonic plates as "samples".
# CommunityMatrix<-abundanceMatrix(DataPBDB,"geoplate")

# Remove taxa that occur in less than 5 samples and samples with fewer than 25 taxa.
# cullMatrix(CommunityMatrix,Rarity=5,Richness=25,Silent=FALSE)

}
\author{
Andrew A. Zaffos
}

