% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_crop.R
\name{VeloxRaster_crop}
\alias{VeloxRaster_crop}
\title{Crop a VeloxRaster object}
\arguments{
\item{y}{An object from which an \code{extent} object can be extracted. Usually a sf, Spatial* or Raster* object.}
}
\value{
Void.
}
\description{
\code{crop}s a VeloxRaster object
}
\details{
Crops a VeloxRaster object to the extent of y.
}
\examples{
## Make VeloxRaster
mat <- matrix(1:100, 10, 10)
vx <- velox(mat, extent=c(0,1,0,1), res=c(0.1,0.1), crs="+proj=longlat +datum=WGS84 +no_defs")
## Crop
vx$crop(c(0.3,0.7,0.3,0.7))
vx$extent

}

