% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R, R/xgboost.R
\name{vetiver_meta}
\alias{vetiver_meta}
\alias{vetiver_create_meta}
\alias{vetiver_create_meta.default}
\alias{vetiver_create_meta.xgb.Booster}
\title{Metadata constructors for \code{vetiver_model()} object}
\usage{
vetiver_meta(user = list(), version = NULL, url = NULL, required_pkgs = NULL)

vetiver_create_meta(model, metadata)

\method{vetiver_create_meta}{default}(model, metadata)

\method{vetiver_create_meta}{xgb.Booster}(model, metadata)
}
\arguments{
\item{user}{Metadata supplied by the user}

\item{version}{Version of the pin}

\item{url}{URL for the pin, if any}

\item{required_pkgs}{Character string of R packages required for prediction}

\item{model}{A trained model, such as an \code{lm()} model or a tidymodels
\code{\link[workflows:workflow]{workflows::workflow()}}.}

\item{metadata}{A list containing additional metadata to store with the pin.
When retrieving the pin, this will be stored in the \code{user} key, to
avoid potential clashes with the metadata that pins itself uses.}
}
\value{
The \code{vetiver_meta()} constructor returns a list. The
\code{vetiver_create_meta} function returns a \code{vetiver_meta()} list.
}
\description{
These are developer-facing functions, useful for supporting new model types.
The metadata stored in a \code{\link[=vetiver_model]{vetiver_model()}} object has four elements:
\itemize{
\item \verb{$user}, the metadata supplied by the user
\item \verb{$version}, the version of the pin (which can be \code{NULL} before pinning)
\item \verb{$url}, the URL where the pin is located, if any
\item \verb{$required_pkgs}, a character string of R packages required for prediction
}
}
\examples{
vetiver_meta()

cars_lm <- lm(mpg ~ ., data = mtcars)
vetiver_create_meta(cars_lm, list())

}
