% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_dch.R
\name{desc_dch}
\alias{desc_dch}
\title{Dechallenge descriptive}
\usage{
desc_dch(.data, drug_s = "drug1", adr_s = "adr1")
}
\arguments{
\item{.data}{A \code{link} data.table.}

\item{drug_s}{A character vector, the drug column(s)}

\item{adr_s}{A character vector, the adverse drug reaction column(s).}
}
\value{
A data.table with one row per drug-adr pair.
\itemize{
\item \code{drug_s} and \code{adr_s}, same as input
\item \code{pos_dch}, number of positive dechallenge cases
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Computes positive
dechallenge counts over a set of adr and drug pairs.
}
\details{
Counts are provided at the \strong{case} level (not the drug-adr pair level).
Positive dechallenge refers to cases where drug was withdrawn or
dose-reduced and reaction abated (in part or in full).
You will need a \code{link} data.table, see \code{\link{link_}}, on which
you have added drugs and adrs with \code{\link[=add_drug]{add_drug()}} and \code{\link[=add_adr]{add_adr()}}.
}
\examples{

link_ <-
  link_ |>
  add_drug(
    d_code = ex_$d_groups_drecno,
    drug_data = drug_
  ) |>
  add_adr(
    a_code = ex_$a_llt,
    adr_data = adr_
  )


desc_dch(link_,
         drug_s = "pd1",
         adr_s = "a_colitis")


# you can vectorize over multiple adrs and drugs

desc_dch(link_,
         drug_s = c("pd1", "pdl1"),
         adr_s = c("a_colitis", "a_pneumonitis"))
}
\seealso{
\code{\link{link_}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=add_adr]{add_adr()}}, \code{\link[=desc_tto]{desc_tto()}}, \code{\link[=desc_rch]{desc_rch()}}
}
\keyword{descriptive}
\keyword{drug-adr-pair}
