% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpit.R
\name{cll}
\alias{cll}
\title{Conditional log-likelihood}
\usage{
cll(object, newdata, cores = 1)
}
\arguments{
\item{object}{an object of class \code{vinereg}.}

\item{newdata}{matrix of response and covariate values for which to compute
the conditional distribution.}

\item{cores}{integer; the number of cores to use for computations.}
}
\description{
Calculates the conditional log-likelihood of the response given the covariates.
}
\examples{
\dontshow{
set.seed(1)
}
# simulate data
x <- matrix(rnorm(500), 250, 2)
y <- x \%*\% c(1, -2)
dat <- data.frame(y = y, x = x, z = as.factor(rbinom(250, 2, 0.5)))

# fit vine regression model
fit <- vinereg(y ~ ., dat)

cll(fit, dat)
fit$stats$cll
}
