% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viralx_knn.R
\name{viralx_knn}
\alias{viralx_knn}
\title{Explain K-Nearest Neighbors Model}
\usage{
viralx_knn(vip_featured, hiv_data, knn_hyperparameters, vip_train, vip_new)
}
\arguments{
\item{vip_featured}{The name of the variable to be explained.}

\item{hiv_data}{The data frame containing the CD4 and viral load data.}

\item{knn_hyperparameters}{A list of hyperparameters to be tuned for the KNN model.}

\item{vip_train}{The training data used for creating the explainer object.}

\item{vip_new}{A new observation for which to generate explanations.}
}
\value{
A data frame containing explanations for the specified variable.
}
\description{
Explains the predictions of a K-Nearest Neighbors (KNN) model for CD4 and
viral load data using the DALEX and DALEXtra packages. It provides insights
into the specified variable's impact on the KNN model's predictions.
}
\examples{
hiv_data <- train2
knn_hyperparameters <- list(neighbors = 5, weight_func = "optimal", dist_power = 0.3304783)
vip_featured <- c("cd_2022")
vip_train <- hiv_data
vip_new <- vip_train[1,]
viralx_knn(vip_featured, hiv_data, knn_hyperparameters, vip_train, vip_new)
}
