% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sp.env.functions.R
\name{custnorm}
\alias{custnorm}
\title{Normal function defined by extremes}
\usage{
custnorm(x, mean, diff, prob)
}
\arguments{
\item{x}{a numeric value or vector. The input environmental variable.}

\item{mean}{a numeric value or vector. The optimum (mean) of the normal curve}

\item{diff}{a numeric value or vector. The absolute difference between the mean and extremes.}

\item{prob}{a numeric value or vector. The percentage of the area under the curve between the
chosen extreme values}
}
\value{
a numeric value or vector resulting from the function
}
\description{
A modified version of the normal function based on three parameters:
\itemize{
\item{the mean}
\item{the absolute difference between the mean and extreme values}
\item{the percentage of area under the curve between the specified extreme values}
}

See the example for an easier understanding.
}
\examples{
# Let's define the response of a species to temperature which
#  - has an optimum at 20 degrees C
#  - occurs 99\% of the time between 13 and 27 degrees C.
# In that case, mean = 20, diff = 7, and prob = 0.99

# First, we generate an arbitrary temperature variable
# between 0 and 30 degrees C
temp <- seq(0, 30, length = 1000)


# Then, we calculate the response to this variable with the chosen values
response <- custnorm(x = temp, mean = 20, diff = 7, prob = .99)

plot(response ~ temp, type = "l")
}
\author{
Boris Leroy \email{leroy.boris@gmail.com}, Florian David

Maintainer: Boris Leroy \email{leroy.boris@gmail.com}
}

