% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{scatterPlot}
\alias{scatterPlot}
\title{Create a scatter plot visualisation from a \verb{<summarised_result>} object}
\usage{
scatterPlot(
  result,
  x,
  y,
  line,
  point,
  ribbon,
  ymin = NULL,
  ymax = NULL,
  facet = NULL,
  colour = NULL,
  group = colour
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{x}{Column or estimate name that is used as x variable.}

\item{y}{Column or estimate name that is used as y variable}

\item{line}{Whether to plot a line using \code{geom_line}.}

\item{point}{Whether to plot points using \code{geom_point}.}

\item{ribbon}{Whether to plot a ribbon using \code{geom_ribbon}.}

\item{ymin}{Lower limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{ymax}{Upper limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{facet}{Variables to facet by, a formula can be provided to specify
which variables should be used as rows and which ones as columns.}

\item{colour}{Columns to use to determine the colors.}

\item{group}{Columns to use to determine the group.}
}
\value{
A plot object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
result <- mockSummarisedResult() |>
  dplyr::filter(variable_name == "age")

scatterPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  line = TRUE,
  point = TRUE,
  ribbon = FALSE,
  facet = age_group ~ sex)
}

}
