% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{splitAll}
\alias{splitAll}
\title{Split all pairs name-level into columns.}
\usage{
splitAll(result, keep = FALSE, fill = "overall", exclude = "variable")
}
\arguments{
\item{result}{A data.frame.}

\item{keep}{Whether to keep the original name-level columns.}

\item{fill}{A character that specifies what value should be filled in when
missing.}

\item{exclude}{Name of a column pair to exclude.}
}
\value{
A dataframe with group, strata and additional as columns.
}
\description{
Pivots the input dataframe so any pair name-level columns are transformed
into columns (name) that contain values from the corresponding level.
}
\examples{
mockSummarisedResult() |>
  splitAll()

}
